#define Version 100     //Version 1.00
#define _SUPPRESS_PLIB_WARNING                                      // required for XC1.33  Later compiler versions will need PLIB to be installed
#include <plib.h>                                                   // the pre Harmony peripheral libraries
#include "CFunctions.h"

//CFUNC RAM locations for audio
#define WAV_STATE       1
#define WAV_PTR         2
#define WAV_SIZE        3
#define WAV_PLAY_PTR    4
#define WAV_PLAY_END    5

#define LPC_COUNTER     6
#define LPC_PTR         7
#define LPC_CURRENT     8
#define LPC_BIT_PTR     9
#define LPC_CONST_PTR   10

#define synthPeriod (CFuncRam[11])
#define synthEnergy (CFuncRam[12])
#define synthK1 (CFuncRam[13])
#define synthK2 (CFuncRam[14])
#define synthK3 (CFuncRam[15])
#define synthK4 (CFuncRam[16])
#define synthK5 (CFuncRam[17])
#define synthK6 (CFuncRam[18])
#define synthK7 (CFuncRam[19])
#define synthK8 (CFuncRam[20])
#define synthK9 (CFuncRam[21])
#define synthK10 (CFuncRam[22])
#define energy (CFuncRam[23])
#define repeat (CFuncRam[24])
#define nextPwm (CFuncRam[25])
#define periodCounter (CFuncRam[26])
#define x0 (CFuncRam[27])
#define x1 (CFuncRam[28])
#define x2 (CFuncRam[29])
#define x3 (CFuncRam[30])
#define x4 (CFuncRam[31])
#define x5 (CFuncRam[32])
#define x6 (CFuncRam[33])
#define x7 (CFuncRam[34])
#define x8 (CFuncRam[35])
#define x9 (CFuncRam[36])
#define x10 (CFuncRam[37])
#define synthRand (CFuncRam[38])
#define CHIRP_SIZE 41
#define uint32_t unsigned int
#define int16_t int
#define int32_t int
#define uint8_t unsigned char
#define int8_t char

//CFUNC RAM locations for GPS
//GPS (most correspond to functions)
#define GPS_PTR         48
#define PARSE_GPS       49
//these are both function calls to set string array pointers
//and CFUNCRAM locations of those pointers
#define GPS_FIRST       50
#define GPS_LAST        60
#define GPS_GET_DEG     61
#define GPS_GET_MIN     62
#define GPS_GET_SEC     63
//Macros etc
//string dim/length of parsers, 0th item is to match
#define GPS_RESULT_LEN  20
#define GPS_RESULT_COUNT 20

//offsets into CONST data
#define tmsEnergy_OFFSET 0
#define tmsPeriod_OFFSET 16
#define tmsK1_OFFSET 80
#define tmsK2_OFFSET 208
#define tmsK3_OFFSET 336
#define tmsK4_OFFSET 352
#define tmsK5_OFFSET 368
#define tmsK6_OFFSET 384
#define tmsK7_OFFSET 400
#define tmsK8_OFFSET 416
#define tmsK9_OFFSET 424
#define tmsK10_OFFSET 432
#define chirp_OFFSET 440

//CFUNC Functions
#define AUDIO_INIT      0
#define AUDIO_SET_PTR   1
#define AUDIO_PLAY      2
#define AUDIO_STOP      3
#define AUDIO_GET_STATE 4
#define AUDIO_DEINIT    5
#define AUDIO_LOOP      6
#define AUDIO_END_LOOP  7
#define AUDIO_LPC_PTR   8
#define AUDIO_LPC_START 9
#define AUDIO_LPC_STOP  10
#define LPC_SET_CONST_PTR 11

//WAV_STATE values
#define AUDIO_STOPPED   0
#define AUDIO_PLAYING   1
#define AUDIO_LOOPING   2
#define AUDIO_LPC       3

//Macros etc
#define AUDIO_SAMPLE_RATE (8000)

#define rev(x) (((x&0xF0)>>7)|((x&0x80)>>5)|((x&0x40)>>3)|((x&0x10)>>1)|((x&0x0F)<<7)|((x&0x08)<<5)|((x&0x04)<<3)|((x&0x01)<<1))
#define hex(x) (((x&0xF)<0xA)?((x&0xF)+'0'):((x&0xF)+'A'-0xA))
#define debug(x) {putConsole(((x>>9)&0xF)+'0');putConsole(((x>>6)&0xF)+'0');putConsole(((x>>3)&0xF)+'0');putConsole(((x>>0)&0xF)+'0');putConsole(13);putConsole(10);}
#define debugHex(x) {putConsole(hex((x>>12)&0xF));putConsole(hex((x>>8)&0xF));putConsole(hex((x>>4)&0xF));putConsole(hex((x>>0)&0xF));putConsole(13);putConsole(10);}

int parseGPS(void){
    int retLen=0;
    int parser;
    int len = *(unsigned char*)(CFuncRam[GPS_PTR]);    
    char* gps= (unsigned char*)(CFuncRam[GPS_PTR]);
    char* target;
    int i,t;
    int startPtr=0;
    int endPtr=0;
    int checksum=0;
    //debugHex(len);
    int done=0;
    int sentenceDone=0;
    while((len>9)&&(!done)){      //need at least 9 bytes to have anything worth doing
        startPtr=0;
        endPtr=0;  
        checksum=0;
        //find first $
        for(i=len;i>0;i--){if(gps[i]=='$'){startPtr=i;}}
        if(startPtr>1){                 //move 1st $ to start
            for(i=startPtr;i<=len;i++){ //all the +1's are due to string starting at 1
                gps[i-startPtr+1]=gps[i];
            }
            len=len-startPtr+1;
        }
        //find first * and ensure two trailing checksum characters available
        for(i=len-2;i>0;i--){if(gps[i]=='*'){endPtr=i;}}
        //check checksum
        if(endPtr>3){
            checksum=0;
            for(i=2;i<endPtr;i++){     //checksum excludes leading $ and trailing *
                checksum=checksum^gps[i];
            }
            if((gps[endPtr+1]==hex((checksum>>4)&0xF))&&(gps[endPtr+2]==hex(checksum&0xF))){
                //checksum OK, parse data here
                //custom parser that reads to/from BASIC strings
                //first item in string array is sentence type to match (GPRMC etc (positions 2-6))
                //remaining items are where data is sent
                for(parser=GPS_FIRST;parser<=GPS_LAST;parser++){     //loop through parsers
                    if(!(CFuncRam[parser])){            //skip if not set
                        continue;
                    }
                    target=(char*)(CFuncRam[parser]);   //load parser target
                    for(i=1;i<=target[0];i++){
                        if(gps[i]!=target[i]){                        
                            i=0xFFF;       //flag mismatch, and run out counter
                        }else{
                            if(i==2){i++;}//ignore 3rd character to allow $GP, $GN etc (i gets inc'ed from 3 to 4 next loop)
                        }
                    }
                    if(i>=0xFFF){continue;} //jump out on mismatch
                    retLen=parser;          //flag which parser matched
                    done=1;                 //so that we only parse one at a time eg for checking multiple instances of GPGSV
                    //process remainder of sentence
                    target=target+GPS_RESULT_LEN+1;
                    target[0]=0;        //null string
                    sentenceDone=0;
                    while((!sentenceDone)&&(i<=len)){
                        if(gps[i]==','){            //next token
                            if((target-CFuncRam[parser])<(GPS_RESULT_LEN+1)*(GPS_RESULT_COUNT-1)){
                                target=target+GPS_RESULT_LEN+1;
                                target[0]=0;        //null string                            
                            }else{
                                sentenceDone=1;  //too many array items                        
                            }

                        }else if(gps[i]=='*'){
                            sentenceDone=1;  //end of sentence marker                        
                        }else{
                            if(target[0]<GPS_RESULT_LEN){   //room in string
                                target[0]=target[0]+1;      //increment index
                                target[target[0]]=gps[i];   //add to string
                            }
                        }
                        i++;
                    }
                }            
            }else{
            }
            //move up by len
            for(i=endPtr;i<=len;i++){ //all the +1's are due to string starting at 1
                gps[i-endPtr+1]=gps[i];
            }
            len=len-endPtr+1;
        }else{
            done=1;         //no *, can't process
        }
    }
    *(unsigned char*)(CFuncRam[GPS_PTR])=len;       //restore this
    return retLen;
}

 char getBits(int n){        //return n bits
     char r=0;
    int m=n;
    while(n){
        if((*(unsigned char*)(CFuncRam[LPC_CURRENT])) & (CFuncRam[LPC_BIT_PTR])){
            r=(r<<1)|1;
        }else{
            r=(r<<1);
        }
        CFuncRam[LPC_BIT_PTR] = CFuncRam[LPC_BIT_PTR]<<1;
        if((CFuncRam[LPC_BIT_PTR]&0xFF) == 0){
            CFuncRam[LPC_CURRENT]++;
            CFuncRam[LPC_BIT_PTR]=1;
        }
        n--;
    }    
    return r;
}

void LPCsample(void){
  char* chirp = (char*)(CFuncRam[LPC_CONST_PTR]+chirp_OFFSET);
  int16_t u0,u1,u2,u3,u4,u5,u6,u7,u8,u9,u10;  
  OC4RS = (nextPwm & 0xFF);
  if (synthPeriod) {
    // Voiced source
    if (periodCounter < synthPeriod) {
      periodCounter++;
    } else {
      periodCounter = 0;
    }
    if (periodCounter < CHIRP_SIZE) {
      u10 = ((chirp[periodCounter]) * (uint32_t) synthEnergy) >> 8;
    } else {
      u10 = 0;
    }
  } else {
    // Unvoiced source
    synthRand = (synthRand >> 1) ^ ((synthRand & 1) ? 0xB800 : 0);
    u10 = (synthRand & 1) ? synthEnergy : -synthEnergy;
  }
  // Lattice filter forward path
  u9 = u10 - (((int16_t)synthK10*x9) >> 7);
  u8 = u9 - (((int16_t)synthK9*x8) >> 7);
  u7 = u8 - (((int16_t)synthK8*x7) >> 7);
  u6 = u7 - (((int16_t)synthK7*x6) >> 7);
  u5 = u6 - (((int16_t)synthK6*x5) >> 7);
  u4 = u5 - (((int16_t)synthK5*x4) >> 7);
  u3 = u4 - (((int16_t)synthK4*x3) >> 7);
  u2 = u3 - (((int16_t)synthK3*x2) >> 7);
  u1 = u2 - (((int32_t)synthK2*x1) >> 15);
  u0 = u1 - (((int32_t)synthK1*x0) >> 15);

  // Output clamp
  if (u0 > 511) u0 = 511;
  if (u0 < -512) u0 = -512;
  
  // Lattice filter reverse path
  x9 = x8 + (((int16_t)synthK9*u8) >> 7);
  x8 = x7 + (((int16_t)synthK8*u7) >> 7);
  x7 = x6 + (((int16_t)synthK7*u6) >> 7);
  x6 = x5 + (((int16_t)synthK6*u5) >> 7);
  x5 = x4 + (((int16_t)synthK5*u4) >> 7);
  x4 = x3 + (((int16_t)synthK4*u3) >> 7);
  x3 = x2 + (((int16_t)synthK3*u2) >> 7);
  x2 = x1 + (((int32_t)synthK2*u1) >> 15);
  x1 = x0 + (((int32_t)synthK1*u0) >> 15);
  x0 = u0;

  nextPwm = (u0>>2)^0x80;
}

void LPCframe(void){
    uint8_t* tmsEnergy = (uint8_t*)(CFuncRam[LPC_CONST_PTR]+tmsEnergy_OFFSET);
    uint8_t* tmsPeriod = (uint8_t*)(CFuncRam[LPC_CONST_PTR]+tmsPeriod_OFFSET);
    int16_t* tmsK1 = (int16_t*)(CFuncRam[LPC_CONST_PTR]+tmsK1_OFFSET);
    int16_t* tmsK2 = (int16_t*)(CFuncRam[LPC_CONST_PTR]+tmsK2_OFFSET);
    int8_t* tmsK3 = (int8_t*)(CFuncRam[LPC_CONST_PTR]+tmsK3_OFFSET);
    int8_t* tmsK4 = (int8_t*)(CFuncRam[LPC_CONST_PTR]+tmsK4_OFFSET);
    int8_t* tmsK5 = (int8_t*)(CFuncRam[LPC_CONST_PTR]+tmsK5_OFFSET);
    int8_t* tmsK6 = (int8_t*)(CFuncRam[LPC_CONST_PTR]+tmsK6_OFFSET);
    int8_t* tmsK7 = (int8_t*)(CFuncRam[LPC_CONST_PTR]+tmsK7_OFFSET);
    int8_t* tmsK8 = (int8_t*)(CFuncRam[LPC_CONST_PTR]+tmsK8_OFFSET);
    int8_t* tmsK9 = (int8_t*)(CFuncRam[LPC_CONST_PTR]+tmsK9_OFFSET);
    int8_t* tmsK10 = (int8_t*)(CFuncRam[LPC_CONST_PTR]+tmsK10_OFFSET);
    
    // Read speech data, processing the variable size frames.

    energy = getBits(4);
    if (energy == 0) {
        // Energy = 0: rest frame
        synthEnergy = 0;
    } else if (energy == 0xf) {
        // Energy = 15: stop frame. Silence the synthesiser.
        synthEnergy = 0;
        synthK1 = 0;
        synthK2 = 0;
        synthK3 = 0;
        synthK4 = 0;
        synthK5 = 0;
        synthK6 = 0;
        synthK7 = 0;
        synthK8 = 0;
        synthK9 = 0;
        synthK10 = 0;
    } else {
        synthEnergy = tmsEnergy[energy];
        repeat = getBits(1);
        synthPeriod = tmsPeriod[getBits(6)];
        // A repeat frame uses the last coefficients
        if (!repeat) {
            // All frames use the first 4 coefficients
            synthK1 = tmsK1[getBits(5)];
            synthK2 = tmsK2[getBits(5)];
            synthK3 = tmsK3[getBits(4)];
            synthK4 = tmsK4[getBits(4)];
            if (synthPeriod) {
                // Voiced frames use 6 extra coefficients.
                synthK5 = tmsK5[getBits(4)];
                synthK6 = tmsK6[getBits(4)];
                synthK7 = tmsK7[getBits(4)];
                synthK8 = tmsK8[getBits(3)];
                synthK9 = tmsK9[getBits(3)];
                synthK10 = tmsK10[getBits(3)];
            }
        }
    }
    if(energy == 0xF){      //end of data marker
        CFuncRam[WAV_STATE]=AUDIO_STOPPED;      //stop
        OC4CON=0;        //shut down PWM
        CFuncRam[LPC_CURRENT]=CFuncRam[LPC_PTR];
        CFuncRam[LPC_BIT_PTR]=1;            //bitmask that gets shuffled around
    }    
}

void T1Int(void) {
    //process WAV data:
    if((CFuncRam[WAV_STATE]==AUDIO_PLAYING)||(CFuncRam[WAV_STATE]==AUDIO_LOOPING)){   //playing wav
        OC4RS=*(unsigned char*)(CFuncRam[WAV_PLAY_PTR]);                //output sample
        CFuncRam[WAV_PLAY_PTR]++;
        if(CFuncRam[WAV_PLAY_PTR]>=CFuncRam[WAV_PLAY_END]){             //end of sample
            if(CFuncRam[WAV_STATE]==AUDIO_LOOPING){                     //loop
                CFuncRam[WAV_PLAY_PTR] = CFuncRam[WAV_PTR]+4;
            }else{
                OC4CON=0;        //shut down PWM
                //RPB13R=0;        //assign nothing to pin 24
                CFuncRam[WAV_STATE]=AUDIO_STOPPED;
                //reset for replay
                CFuncRam[WAV_PLAY_PTR] = CFuncRam[WAV_PTR]+4;                
            }
        }
    }
    if(CFuncRam[WAV_STATE]==AUDIO_LPC){                 //playing LPC data
        LPCsample();
        CFuncRam[LPC_COUNTER]++;
        if(CFuncRam[LPC_COUNTER]>199){                  //new frame every 200 samples = 25ms = 1/40s
            CFuncRam[LPC_COUNTER]=0;
            LPCframe();
        }
    }
    IFS0bits.T1IF=0;    //clear flag
}

__attribute__((noinline)) void getFPC(void *a, void *b, volatile unsigned int *c) {
    *c = (unsigned int) (__builtin_return_address (0) - (b -a)) ;
}

long long int main(long long int* function, long long int* p1){
    char* s;
        //AUDIO functions:
    if( *function == AUDIO_INIT ) {                  //set up 1 as counter
        volatile unsigned int libAddr;
        getFPC(NULL,&&getFPCLab,&libAddr) ;         // warning can be ignored, stupid editor
        getFPCLab: { }
        CFuncT1=(unsigned int)&T1Int + libAddr;     //set interrupt location
        T1CONbits.ON=0;     //reset T1
        T1CONbits.TCKPS=0;  //1:1 prescaler
        T1CONbits.TCS=0;    //internal source
        PR1=CurrentCpuSpeed/AUDIO_SAMPLE_RATE;
        TMR1 = 0;           //reset
        IFS0bits.T1IF=0;    //clear flag
        IEC0bits.T1IE=1;    //enable
        IPC1bits.T1IP=1;    //priority 1
        T1CONbits.ON=1;     //T1 on
        return PR1;
    }else if( *function == AUDIO_SET_PTR ) {
        if(!(*p1)){return -1;}
        CFuncRam[WAV_PTR] = *p1;       //set address        
        CFuncRam[WAV_SIZE] = (*(unsigned long*)CFuncRam[WAV_PTR]);//size is first word of data
        CFuncRam[WAV_PLAY_PTR] = CFuncRam[WAV_PTR]+4;             //start of data
        CFuncRam[WAV_PLAY_END] = CFuncRam[WAV_PLAY_PTR] + CFuncRam[WAV_SIZE];
        return (unsigned int)CFuncRam[WAV_SIZE];
    }else if( *function == AUDIO_PLAY ) {
        if(CFuncRam[WAV_STATE] != AUDIO_STOPPED){return CFuncRam[WAV_STATE];}   //if already doing something else, don't change        
        if(!(CFuncRam[WAV_PTR])){return AUDIO_STOPPED;}       //avoid null
        if(!(CFuncRam[WAV_SIZE])){return AUDIO_STOPPED;}      //avoid empty
        CFuncRam[WAV_STATE] = AUDIO_PLAYING;        //run
        //set up PWM
        T2CON=0;        //shut down
        PR2=256;        //so that we can use 8-bit data
        //T2CON=96;       //PS=64 => 2.4kHz
        T2CON=0;        //PS=1 => 156kHz
        //T2CON=16;        //PS=2 => 78kHz
        //T2CON=32;       //PS=4 => 39kHz
        T2CONSET=32768; //on        
        //OC4 is PIN 24/PWM2B/RB13
        OC4CON=0;
        OC4CON=6;       //PWM, no fault pin    
        OC4RS=127;     //test
        OC4CONSET=32768;//enable
        RPB13R=5;        //assign OC4 to pin 24
        return CFuncRam[WAV_STATE];
    }else if( *function == AUDIO_STOP ) {
        CFuncRam[WAV_STATE] = AUDIO_STOPPED;        //not run
        OC4CON=0;                
        RPB13R=0;        //assign nothing to pin 24
    }else if( *function == AUDIO_GET_STATE ) {
        return (unsigned int)CFuncRam[WAV_STATE];
    }else if( *function == AUDIO_DEINIT ) {
        T1CONbits.ON=0;     //reset T1
        IEC0bits.T1IE=0;    //disable                
    }else if( *function == AUDIO_LOOP ) {
        if(CFuncRam[WAV_STATE] != AUDIO_STOPPED){return CFuncRam[WAV_STATE];}   //if already doing something else, don't change
        if(!(CFuncRam[WAV_PTR])){return AUDIO_STOPPED;}       //avoid null
        if(!(CFuncRam[WAV_SIZE])){return AUDIO_STOPPED;}      //avoid empty
        CFuncRam[WAV_STATE] = AUDIO_LOOPING;        //run and loop
        T2CON=0;        //shut down
        PR2=256;        //so that we can use 8-bit data
        //T2CON=96;       //PS=64 => 2.4kHz
        T2CON=0;        //PS=1 => 156kHz
        //T2CON=16;        //PS=2 => 78kHz
        //T2CON=32;       //PS=4 => 39kHz
        T2CONSET=32768; //on        
        //OC4 is PIN 24/PWM2B/RB13
        OC4CON=0;
        OC4CON=6;       //PWM, no fault pin    
        OC4RS=127;     //test
        OC4CONSET=32768;//enable
        RPB13R=5;        //assign OC4 to pin 24
        return CFuncRam[WAV_STATE];
    }else if( *function == AUDIO_END_LOOP ) {    //revert if looping
        if(CFuncRam[WAV_STATE]==AUDIO_LOOPING){CFuncRam[WAV_STATE]=AUDIO_PLAYING;}
        return CFuncRam[WAV_STATE];
    }else if( *function == AUDIO_LPC_PTR ) {
        if(!(*p1)){return -1;}
        CFuncRam[LPC_PTR] = *p1;       //set address        
        return (unsigned int)CFuncRam[LPC_PTR];
    }else if( *function == AUDIO_LPC_START ) {
        if(CFuncRam[WAV_STATE] != AUDIO_STOPPED){return CFuncRam[WAV_STATE];}   //if already doing something else, don't change
        if(!(CFuncRam[LPC_PTR])){return AUDIO_STOPPED;}       //avoid null
        CFuncRam[WAV_STATE] = AUDIO_LPC;                       //run
        //set up PWM
        T2CON=0;        //shut down
        PR2=256;        //so that we can use 8-bit data
        //T2CON=96;       //PS=64 => 2.4kHz
        T2CON=0;        //PS=1 => 156kHz
        //T2CON=16;        //PS=2 => 78kHz
        //T2CON=32;       //PS=4 => 39kHz
        T2CONSET=32768; //on        
        //OC4 is PIN 24/PWM2B/RB13
        OC4CON=0;
        OC4CON=6;       //PWM, no fault pin    
        OC4RS=127;     //test
        OC4CONSET=32768;//enable
        RPB13R=5;        //assign OC4 to pin 24
        synthRand=1;
        CFuncRam[LPC_CURRENT]=CFuncRam[LPC_PTR];
        CFuncRam[LPC_BIT_PTR]=1;            //bitmask that gets shuffled around
        CFuncRam[LPC_COUNTER]=0;            //reset
        return CFuncRam[WAV_STATE];
    }else if( *function == AUDIO_LPC_STOP ) {
        if(CFuncRam[WAV_STATE] != AUDIO_LPC){return CFuncRam[WAV_STATE];}   //if already doing something else, don't change
        CFuncRam[WAV_STATE] = AUDIO_STOPPED;                       //stop
        OC4CON=0;        //shut down PWM
        CFuncRam[LPC_CURRENT]=CFuncRam[LPC_PTR];
        CFuncRam[LPC_BIT_PTR]=1;            //bitmask that gets shuffled around
        return CFuncRam[WAV_STATE];
    }else if( *function == LPC_SET_CONST_PTR ) {    //for consts needed
        if(!(*p1)){return -1;}
        CFuncRam[LPC_CONST_PTR] = *p1;       //set address        
        return (unsigned int)CFuncRam[LPC_CONST_PTR];        

        //GPS functions:
    }else if( *function == GPS_PTR ) {                      //set up GPS pointer
        if(!(*p1)){return 0;}
        CFuncRam[GPS_PTR] = *p1;                      //set address        
        return 1;                                     //OK
    }else if( *function == PARSE_GPS ) {              //parse GPS 
        //MM string format is byte[0]=length, remainder = data
        return parseGPS();                            //for tidyness
    }else if((*function >=GPS_FIRST)&&(*function <=GPS_LAST)) {    //set parser array pointer
        if(!(*p1)){return 0;}
        CFuncRam[*function] = *p1;                    //set address        
        return 1;                                     //OK
    }else if( *function == GPS_GET_DEG ) {            //convert/extract to degrees
        if(!(*p1)){return -1;}
        s=(char*)(*p1);
        if(s[0]<6){return -1;}                        //not enough to do
        int r=0;
        if(s[4]=='.'){  //dmm.sss form
            r=(s[1]-'0');
            return r;
        }else if(s[5]=='.'){  //ddmm.sss form
            r=(s[1]-'0')*10 + (s[2]-'0');
            return r;
        }else if(s[6]=='.'){  //dddmm.sss form
            r=(s[1]-'0')*100 + (s[2]-'0')*10 + (s[3]-'0');
            return r;
        }else{return -1;}        
    }else if( *function == GPS_GET_MIN ) {            //convert/extract to minutes
        if(!(*p1)){return -1;}
        s=(char*)(*p1);
        //return s[0];                                //length
        if(s[0]<6){return -1;}                        //not enough to do
        int r=0;
        if(s[4]=='.'){  //dmm.sss form
            r=(s[2]-'0')*10 + (s[3]-'0');
            return r;
        }else if(s[5]=='.'){  //ddmm.sss form
            r=(s[3]-'0')*10 + (s[4]-'0');
            return r;
        }else if(s[6]=='.'){  //dddmm.sss form
            r=(s[4]-'0')*10 + (s[5]-'0');
            return r;
        }else{return -1;}        
    }else if( *function == GPS_GET_SEC ) {            //convert/extract to 10kths of minute
        if(!(*p1)){return -1;}
        s=(char*)(*p1);
        //return s[0];                                //length
        if(s[0]<6){return -1;}                        //not enough to do
        int r=0;
        if(s[4]=='.'){  //dmm.sss form
            r=r+(s[5]-'0')*10000;
            r=r+(s[6]-'0')*1000;
            if(s[0]>=7){r=r+(s[7]-'0')*100;}
            if(s[0]>=8){r=r+(s[8]-'0')*10;}
            if(s[0]>=9){r=r+(s[9]-'0');}  
            return r;
        }else if(s[5]=='.'){  //ddmm.sss form
            r=r+(s[6]-'0')*10000;
            if(s[0]>=7){r=r+(s[7]-'0')*1000;}
            if(s[0]>=8){r=r+(s[8]-'0')*100;}
            if(s[0]>=9){r=r+(s[9]-'0')*10;}            
            if(s[0]>=10){r=r+(s[10]-'0');}                        
            return r;
        }else if(s[6]=='.'){  //dddmm.sss form
            if(s[0]>=7){r=r+(s[7]-'0')*10000;}
            if(s[0]>=8){r=r+(s[8]-'0')*1000;}
            if(s[0]>=9){r=r+(s[9]-'0')*100;}            
            if(s[0]>=10){r=r+(s[10]-'0')*10;}                        
            if(s[0]>=11){r=r+(s[11]-'0');}                        
            return r;
        }else{return -1;}        
    }else{                          //unused codepoint
        return *function;   
    }
    return 0;
 }
